/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: APIInterface.h 6424 2014-07-01 12:15:23Z stephans $
   Last Modification:
    $Author: stephans $
    $Date: 2014-07-01 14:15:23 +0200 (Di, 01 Jul 2014) $
    $Revision: 6424 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Declaration of the cifX API interface class
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     2         01.04.2011  SS       Connection state added (m_fConnectionValid)
     1         xx                   created
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file APIInterface.h
/// Declaration of the cifX API interface class
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "HilTransport.h"
#include "cifXUser.h"

#pragma warning(push)
#pragma warning(disable: 4702)
#include <vector>
#include <map>
#include <list>
#pragma warning(pop)

class CDevice;
class CChannel;
class CTransportLayer;

typedef struct
{
  HIL_TRANSPORT_HEADER tHeader;                      /**< Transport header of the transport packet */
  uint8_t*             pbData;                       /**< Data pointer for the data transport */

} HIL_TRANSPORT_PACKET, *PHIL_TRANSPORT_PACKET;

///////////////////////////////////////////////////////////////////////////////////////////
/// \class CcifXAPI
/// Virtual class defining the API functions which must be implemented for a data
/// transfer
///////////////////////////////////////////////////////////////////////////////////////////
class CcifXAPI
{
public:
  //virtual long xDriverEnumBoards           ( CIFXHANDLE  hDriver, uint32_t ulBoard, uint32_t ulSize, void* pvBoardInfo) = 0;
  //virtual long xDriverEnumChannels         ( CIFXHANDLE  hDriver, uint32_t ulBoard, uint32_t ulChannel, uint32_t ulSize, void* pvChannelInfo) = 0;

  ///* System device depending functions */
  virtual int32_t xSysdeviceOpen              ( CIFXHANDLE  hDriver, char*   szBoard, CIFXHANDLE* phSysdevice) = 0;
  virtual int32_t xSysdeviceClose             ( CIFXHANDLE  hSysdevice) = 0;
  virtual int32_t xSysdeviceGetMBXState       ( CIFXHANDLE  hSysdevice, uint32_t* pulRecvPktCount, uint32_t* pulSendPktCount) = 0; 
  virtual int32_t xSysdevicePutPacket         ( CIFXHANDLE  hSysdevice, CIFX_PACKET* ptSendPkt, uint32_t ulTimeout) = 0;
  virtual int32_t xSysdeviceGetPacket         ( CIFXHANDLE  hSysdevice, uint32_t ulSize, CIFX_PACKET* ptRecvPkt, uint32_t ulTimeout) = 0;
  virtual int32_t xSysdeviceInfo              ( CIFXHANDLE  hSysdevice, uint32_t ulCmd, uint32_t ulSize, void* pvInfo) = 0;

  virtual int32_t xSysdeviceFindFirstFile     ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;
  virtual int32_t xSysdeviceFindNextFile      ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;
  virtual int32_t xSysdeviceDownload          ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, uint32_t ulMode, char* szFileName, uint8_t* pabFileData, uint32_t ulFileSize, 
                                                                    PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;
  virtual int32_t xSysdeviceUpload            ( CIFXHANDLE  hSysdevice, uint32_t ulChannel, uint32_t ulMode, char* szFilename, uint8_t* pabFileData, uint32_t* pulFileSize, 
                                                                    PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;

  virtual int32_t xSysdeviceReset             ( CIFXHANDLE  hSysdevice, uint32_t ulTimeout) = 0;

  ///* Channel depending functions */
  virtual int32_t xChannelOpen                ( CIFXHANDLE  hDriver,  char* szBoard, uint32_t ulChannel, CIFXHANDLE* phChannel) = 0;
  virtual int32_t xChannelClose               ( CIFXHANDLE  hChannel) = 0;
  virtual int32_t xChannelFindFirstFile       ( CIFXHANDLE  hChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;
  virtual int32_t xChannelFindNextFile        ( CIFXHANDLE  hChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;

  virtual int32_t xChannelDownload            ( CIFXHANDLE  hChannel, uint32_t ulMode, char* szFileName, uint8_t* pabFileData, uint32_t ulFileSize, 
                                                                  PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;
  virtual int32_t xChannelUpload              ( CIFXHANDLE  hChannel, uint32_t ulMode, char* szFileName, uint8_t* pabFileData, uint32_t* pulFileSize,
                                                                  PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser) = 0;

  virtual int32_t xChannelGetMBXState         ( CIFXHANDLE  hChannel, uint32_t* pulRecvPktCount, uint32_t* pulSendPktCount) = 0;
  virtual int32_t xChannelPutPacket           ( CIFXHANDLE  hChannel, CIFX_PACKET*  ptSendPkt, uint32_t ulTimeout) = 0;
  virtual int32_t xChannelGetPacket           ( CIFXHANDLE  hChannel, uint32_t ulSize, CIFX_PACKET* ptRecvPkt, uint32_t ulTimeout) = 0;
  virtual int32_t xChannelGetSendPacket       ( CIFXHANDLE  hChannel, uint32_t ulSize, CIFX_PACKET* ptRecvPkt) = 0;

  virtual int32_t xChannelConfigLock          ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState, uint32_t ulTimeout) = 0;
  virtual int32_t xChannelReset               ( CIFXHANDLE  hChannel, uint32_t ulResetMode, uint32_t ulTimeout) = 0;
  virtual int32_t xChannelInfo                ( CIFXHANDLE  hChannel, uint32_t ulSize, void* pvChannelInfo) = 0;
  virtual int32_t xChannelWatchdog            ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulTrigger) = 0;
  virtual int32_t xChannelHostState           ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState, uint32_t ulTimeout) = 0;
  virtual int32_t xChannelBusState            ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t* pulState, uint32_t ulTimeout) = 0;

  virtual int32_t xChannelIOInfo              ( CIFXHANDLE  hChannel, uint32_t ulCmd,        uint32_t ulAreaNumber, uint32_t ulSize, void* pvData) = 0;
  virtual int32_t xChannelIORead              ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulOffset,     uint32_t ulDataLen, void* pvData, uint32_t ulTimeout) = 0;
  virtual int32_t xChannelIOWrite             ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulOffset,     uint32_t ulDataLen, void* pvData, uint32_t ulTimeout) = 0; 
  virtual int32_t xChannelIOReadSendData      ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulOffset,     uint32_t ulDataLen, void* pvData) = 0;

  virtual int32_t xChannelControlBlock        ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData) = 0;
  virtual int32_t xChannelCommonStatusBlock   ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData) = 0;
  virtual int32_t xChannelExtendedStatusBlock ( CIFXHANDLE  hChannel, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData) = 0;
  virtual int32_t xChannelUserBlock           ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t ulCmd, uint32_t ulOffset, uint32_t ulDataLen, void* pvData) = 0;

  virtual int32_t xChannelPLCMemoryPtr        ( CIFXHANDLE  hChannel, uint32_t ulCmd,        void* pvMemoryInfo) = 0;
  virtual int32_t xChannelPLCIsReadReady      ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t* pulReadState) = 0;
  virtual int32_t xChannelPLCIsWriteReady     ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber, uint32_t* pulWriteState) = 0;
  virtual int32_t xChannelPLCActivateWrite    ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber) = 0;
  virtual int32_t xChannelPLCActivateRead     ( CIFXHANDLE  hChannel, uint32_t ulAreaNumber) = 0;
};

class CDataLayer : public CcifXAPI
{
  CDataLayer();

public:
  CDataLayer(CTransportLayer* pcTransportLayer)
    : m_pcTransportLayer(pcTransportLayer)
    , m_fConnectionValid(false)
  {
  }

  virtual ~CDataLayer()
  {
  }

  virtual bool            ReceiveData(PHIL_TRANSPORT_PACKET ptPacket)  = 0;
  virtual void            SendComplete(PHIL_TRANSPORT_HEADER ptHeader) = 0;

  virtual int32_t         Init(void)   = 0;
  virtual void            Deinit(void) = 0;
  
  virtual int32_t         EnumDevice(uint32_t ulBoard, uint32_t ulSize, void* pvBoardInfo) = 0;
  virtual int32_t         EnumChannel(uint32_t ulBoard, uint32_t ulChannel, uint32_t ulSize, void* pvChannelInfo) = 0;
  virtual int32_t         RestartDevice(char* szBoard) = 0;

  CTransportLayer*        GetTransportLayer(void) { return m_pcTransportLayer; }
  bool                    ConnectionValid(void) { return m_fConnectionValid; }

protected:
  CTransportLayer*        m_pcTransportLayer;
  bool                    m_fConnectionValid;   //!< Connection state
};

